package edu.uky.ai.csp.kr;

/**
 * Constrains two variables to have the same value.
 * 
 * @author Stephen G. Ware
 */
public class EqualsConstraint extends Constraint {

	/**
	 * Constructs a new equals constraint object.
	 * 
	 * @param left the left hand side of the constraint
	 * @param right the right hand side of the constraint
	 */
	public EqualsConstraint(Variable left, Variable right) {
		super(left, right);
	}

	@Override
	public String toString() {
		return "(" + left + " == " + right + ")";
	}
	
	@Override
	protected boolean testValues(Solution solution, Object left, Object right) {
		return left == right;
	}
}
